// import { PrismaClient } from "@prisma/client";
// import jwt from "jsonwebtoken"

const { PrismaClient } = require("@prisma/client");
const jwt = require('jsonwebtoken');

const prisma = new PrismaClient()


module.exports.AddCategory = async (req, res) => {

    const token = req.cookies.access_token;
    if (!token) {
        return res.status(401).json({
            message: "unauthorized user"
        })
    } else {
        jwt.verify(token, process.env.JWT_SECRET, async (err, userInfo) => {
            if (err) {
                return res.status(401).json({
                    message: "unauthorized user"
                })
            } else {
                console.log(userInfo)
                const { category } = req.body;
                console.log(category)
                // Check if category already exists in the database
                try {
                    const CatExists = await prisma.category?.findFirst({
                        where: {
                            category: category
                        }

                    })
                    if (CatExists) {
                        res.status(400).json({
                            message: "category already exists"
                        })
                    } else {

                        try {
                            const catResponse = await prisma.category.create({
                                data: {
                                    category
                                }
                            });
                            console.log(catResponse)
                            res.status(200).json({
                                message: "category created successfully"

                            })

                        } catch (err) {
                            console.log("CREATE_CAT_ERR", err)
                            res.status(500).json("something went wrong")
                        }

                    }

                } catch (err) {
                    console.log("FIND CATEGORY ERR", err)
                }

            }
        })
    }


}


module.exports.getCategories = async (req, res) => {
    try {
        const getAllCategories = await prisma.category.findMany({
            select: {
                id: true,
                category: true,
            }
        })
        res.status(200).json(getAllCategories)

    } catch (err) {
        console.log("GET_CAT_ERROR", err)
    }
}
module.exports.getOneCategory = async (req, res) => {
    try {
        const id = parseInt(req.params.id);
        const category = await prisma.category.findUnique({
            where: {
                id: id
            },
            select: {
                id: true,
                category: true,
            }
        })
        res.status(200).json(category)
        console.log("selected Category", category)
    } catch (err) {
        console.log("GET_ONE_CAT_ERROR", err)
    }
}


module.exports.NoOfCategories = async (req, res) => {

    try {
        const countCategories = await prisma.category.count()
        res.status(200).json(countCategories)

    } catch (err) {
        console.log("NO_OF_CATS_ERROR", err)
    }
}

module.exports.DeleteCategory = async (req, res) => {

    const token = req.cookies.access_token;
    if (!token) {
        return res.status(401).json({
            message: "unauthorized user"
        })
    } else {
        jwt.verify(token, process.env.JWT_SECRET, async (err, userInfo) => {
            if (err) {
                return res.status(401).json({
                    message: "unauthorized user"
                })
            } else {
                const id = parseInt(req.params.id);

                // check if the category is being used by a post
                const categoryUsed = await prisma.post.count({
                    where: {
                        categoryId: id
                    }
                })
                if (categoryUsed) {
                    res.status(400).json({
                        message: "category is being used by a post. Edit the post and select another category"
                    })

                } else {

                    try {
                        const deleteCategory = await prisma.category.delete({
                            where: {
                                id: id
                            }
                        })
                        res.status(200).json({
                            message: "category deleted successfully"
                        })
                    } catch (err) {
                        console.log("DELETE_CAT_ERROR", err)
                    }
                }
            }
        })
    }
}
// update category
module.exports.UpdateCategory = async (req, res) => {
    const token = req.cookies.access_token;

    if (!token) {
        return res.status(401).json({
            message: "unauthorized user"
        })
    } else {
        jwt.verify(token, process.env.JWT_SECRET, async (err, userInfo) => {
            if (err) {
                return res.status(401).json({
                    message: "unauthorized user"
                })
            } else {
                const id = parseInt(req.params.id);
                const category = req.body.updatecat;

                try {
                    const updateCategory = await prisma.category.update({
                        where: {
                            id: id
                        },
                        data: {
                            category
                        }
                    })
                    res.status(200).json({
                        message: "category updated successfully"
                    })
                } catch (err) {
                    console.log("UPDATE_CAT_ERROR", err)
                }
            }
        })
    }
}
