// import { PrismaClient } from "@prisma/client";
// import jwt from 'jsonwebtoken'

const { PrismaClient } = require("@prisma/client");
const jwt = require('jsonwebtoken');

const prisma = new PrismaClient()

module.exports.AddPost = async (req, res) => {
    

    const token = req.cookies.access_token;

    if (!token) {
        res.status(401).json({
            message: "unauthorized User"
        })
    } else {
        jwt.verify(token, process.env.JWT_SECRET, async (err, userInfo) => {
            if (err) {
                return res.status(401).json({
                    message: "unauthorized user"
                })
            } else {

                const { title, slug, content, categoryId, ImgUrl } = req.body;
                // Validate required fields
                if (!title || !slug || !content || !categoryId || !ImgUrl) {
                    return res.status(400).json({ message: 'Required field missing' });
                }
                // ensure that the slug is unique
                const slugExists = await prisma.post.findUnique({
                    where: {
                        slug: slug
                    }
                })
                if (slugExists) {
                    return res.status(400).json({ message: 'Another post with this title already exists' });
                }

                // turn CategoryId to int
                const catId = parseInt(categoryId)

                try {
                    const post = await prisma.post.create({
                        data: {
                            title,
                            slug,
                            content,
                            ImgUrl: ImgUrl,
                            isPublished: true,
                            category: {
                                connect: {
                                    id: catId
                                }
                            },
                            Author: {
                                connect: {
                                    id: userInfo.id
                                }
                            }
                        }
                    })

                    console.log(post)
                    res.status(200).json({
                        message: "published successfully"
                    })

                } catch (error) {
                    console.log("ADD_POST_ERROR", error)
                }



            }
        })

    }

}

// Add Draft Post

module.exports.AddDraftPost = async (req, res) => {

    const token = req.cookies.access_token;

    if (!token) {
        res.status(401).json({
            message: "unauthorized User"
        })
    } else {
        jwt.verify(token, process.env.JWT_SECRET, async (err, userInfo) => {
            if (err) {
                return res.status(401).json({
                    message: "unauthorized user"
                })
            } else {

                const { title, slug, content, categoryId, ImgUrl } = req.body;
                // Validate required fields
                if (!title || !slug || !content || !categoryId || !ImgUrl) {
                    return res.status(400).json({ message: 'Required fields missing' });
                }
                // ensure that the slug is unique
                const slugExists = await prisma.post.findUnique({
                    where: {
                        slug: slug
                    }
                })
                if (slugExists) {
                    return res.status(400).json({ message: 'Another post with this title already exists' });
                }
                // turn CategoryId to int
                const catId = parseInt(categoryId)

                try {
                    const post = await prisma.post.create({
                        data: {
                            title,
                            slug,
                            content,
                            ImgUrl: ImgUrl,
                            isPublished: false,
                            category: {
                                connect: {
                                    id: catId
                                }
                            },
                            Author: {
                                connect: {
                                    id: userInfo.id
                                }
                            }
                        }
                    })
                    console.log(post)
                    res.status(200).json({
                        message: "draft created successfully"
                    })

                } catch (error) {
                    console.log("ADD_POST_ERROR", error)
                }



            }
        })

    }


}

// Get all Posts
module.exports.GetPosts = async (req, res) => {
    try {

        const posts = await prisma.post.findMany({
            include: {
                category: true
            }

        })

        res.status(200).json(posts)
    } catch (err) {
        console.log("GET_POST_ERR", err)
    }

}

// Get A single Post

module.exports.GetSinglePost = async (req, res) => {

    const id = parseInt(req.params.id);

    try {
        const post = await prisma.post.findUnique({
            where: {
                id
            }
        })
        res.status(200).json(post)
        // console.log(post)

    } catch (err) {
        console.log("GET_SINGLE_POST_ERR", err)
    }
}

// Get no. of all posts
module.exports.GetNoOfPosts = async (req, res) => {
    try {
        const posts = await prisma.post.count()
        res.status(200).json(posts)
    } catch (err) {
        console.log("GET_POSTCOUNT_ERR", err)
    }
}

// Get No. of Published posts
module.exports.PublishedPostsCount = async (req, res) => {
    try {
        const published = await prisma.post.count({
            where: {
                isPublished: true
            }
        })
        res.status(200).json(published)
    } catch (err) {
        console.log("PUBLISHED_POSTS_ERR", err)
    }
}

// Filter by Published posts only
module.exports.GetPublished = async (req, res) => {
    try {
        const publishedPosts = await prisma.post.findMany({
            where: {
                isPublished: true
            },
            include: {
                category: true
            }
        })
        res.status(200).json(publishedPosts)

    } catch (err) {

    }
}

// Get no of Draft Posts
module.exports.DraftPostsCount = async (req, res) => {
    try {
        const Draft = await prisma.post.count({
            where: {
                isPublished: false


            }

        })

        res.status(200).json(Draft)
    } catch (err) {
        console.log("DRAFT_POSTS_ERR", err)
    }
}

// Filter by Draft posts only
module.exports.GetDrafts = async (req, res) => {
    try {
        const draftPosts = await prisma.post.findMany({
            where: {
                isPublished: false
            },
            include: {
                category: true
            }
        })
        res.status(200).json(draftPosts)

    } catch (err) {

    }
}

// Delete a post
module.exports.DeletePost = async (req, res) => {
    const token = req.cookies.access_token;


    if (!token) {
        return res.status(401).json({
            message: "unauthorized user"
        })
    } else {
        jwt.verify(token, process.env.JWT_SECRET, async (err, userInfo) => {
            if (err) {
                return res.status(401).json({
                    message: "unauthorized user"
                })
            } else {

                // Check if author is the same as the post author
                const postId = parseInt(req.params.id)
                const post = await prisma.post.findUnique({
                    where: {
                        id: postId
                    },
                    include: {
                        Author: true
                    }

                })
                if (post.Author.id !== userInfo.id) {
                    return res.status(401).json({
                        message: "only author can delete the post"
                    })
                } else {
                    try {
                        const deletePost = await prisma.post.delete({
                            where: {
                                id: postId
                            }
                        })
                        res.status(200).json({
                            message: "post deleted successfully"
                        })
                    } catch (err) {
                        console.log("DELETE_POST_ERR", err)
                    }
                }

            }
        })
    }
}

// Update and post as published
module.exports.UpdatePublishedPost = async (req, res) => {

    const token = req.cookies.access_token;
    if (!token) {
        return res.status(401).json({
            message: "unauthorized user"
        })
    } else {

        jwt.verify(token, process.env.JWT_SECRET, async (err, userInfo) => {
            if (err) {
                return res.status(401).json({
                    message: "unauthorized user"
                })
            } else {
                const postId = parseInt(req.params.id)
                try {

                    const post = await prisma.post.findUnique({
                        where: {
                            id: postId
                        },
                        include: {
                            Author: true
                        }
                    })
                    if (post.Author.id !== userInfo.id) {
                        return res.status(401).json({
                            message: "only author can update the post"
                        })
                    } else {
                        const { title, slug, content, ImgUrl, categoryId } = req.body;
                        // Validate required fields
                        if (!title || !slug || !content || !categoryId || !ImgUrl) {
                            return res.status(400).json({ message: 'Required field missing' });
                        }
                        // ensure that the slug is unique
                        const slugExists = await prisma.post.findUnique({
                            where: {
                                slug: slug,
                                NOT : {
                                    id : postId
                                }
                            }
                        })
                        if (slugExists) {
                            return res.status(400).json({ message: 'Another post with this title already exists' });
                        }
                        console.log("UPDATE_PUBLISHED_POST_DATA", req.body)
                        const catid = parseInt(categoryId)
                        const updatePost = await prisma.post.update({
                            where: {
                                id: postId
                            },
                            data: {
                                title,
                                slug,
                                content,
                                ImgUrl,
                                isPublished: true,
                                categoryId: catid
                            }
                        })

                        res.status(200).json({ updatePost })


                    }


                } catch (err) {
                    console.log("UPDATE_POST_ERR", err)
                }


            }

        })

    }

}


// Update post and Save as Draft
module.exports.UpdateDraftPost = async (req, res) => {
    const token = req.cookies.access_token;
    if (!token) {
        return res.status(401).json({
            message: "unauthorized user"
        })
    } else {

        jwt.verify(token, process.env.JWT_SECRET, async (err, userInfo) => {
            if (err) {
                return res.status(401).json({
                    message: "unauthorized user"
                })
            } else {
                const postId = parseInt(req.params.id)
                try {

                    const post = await prisma.post.findUnique({
                        where: {
                            id: postId
                        },
                        include: {
                            Author: true
                        }
                    })
                    if (post.Author.id !== userInfo.id) {
                        return res.status(401).json({
                            message: "only author can update the post"
                        })
                    } else {
                        const { title, slug, content, ImgUrl, categoryId } = req.body;
                        // Validate required fields
                        if (!title || !slug || !content || !categoryId || !ImgUrl) {
                            return res.status(400).json({ message: 'Required field missing' });
                        }
                        // ensure that the slug is unique
                        const slugExists = await prisma.post.findUnique({
                            where: {
                                slug: slug,
                                NOT : {
                                    id : postId
                                }
                            }
                        })
                        if (slugExists) {
                            return res.status(400).json({ message: 'Another post with this title already exists' });
                        }
                        console.log("UPDATE_PUBLISHED_DRAFT_DATA", req.body)
                        const catid = parseInt(categoryId)
                        const updatePost = await prisma.post.update({
                            where: {
                                id: postId
                            },
                            data: {
                                title,
                                slug,
                                content,
                                ImgUrl,
                                isPublished: false,
                                categoryId: catid
                            }
                        })

                        res.status(200).json({ updatePost })


                    }


                } catch (err) {
                    console.log("UPDATE_DRAFT_POST_ERR", err)
                }


            }

        })

    }

}