// import express from 'express'
// import authRouter from './routes/auth.js'
// import categoryRouter from './routes/categories.js'
// import postRouter from './routes/post.js'
// import usersRouter from './routes/users.js'
// import cors from 'cors'
// import cookieParser from 'cookie-parser'
// import multer from 'multer'
// import path from 'path'

const express = require('express');
const authRouter = require('./routes/auth');
const categoryRouter = require('./routes/categories');
const postRouter = require('./routes/post');
const usersRouter = require('./routes/users');
const cors = require('cors');
const cookieParser = require('cookie-parser');
const multer = require('multer');
const path = require('path');


const app = express()

app.use(express.json())
app.use(cookieParser())
app.use(
    cors({
        origin: process.env.ORIGIN_URL,
        methods: 'GET, POST, PUT, DELETE, PATCH, HEAD',
        credentials: true
    })
)

// Multer Middleware
const storage = multer.diskStorage({
    destination: (req, file, cb) => {
        // cb(null, '../resort-dashboard/public/uploads')
        cb(null, '/uploads')
    },
    filename: (req, file, cb) => {
        cb(null, Date.now() + '-' + file.originalname)
    }
})

const upload = multer({ storage: storage })

app.post('/api_v1/upload', upload.single('file'), (req, res) => {
    const file = req.file
    if (!file) {
        res.status(400).json({ message: 'No image uploaded' })
    } else {

        console.log("FILE", file)

        res.status(200).json(file.filename)
    }
})


// Mount the AuthRouter
app.use('/api_v1/auth', authRouter)
app.use('/api_v1', categoryRouter)
app.use('/api_v1', usersRouter)
// app.use('/uploads', express.static(path.join(__dirname, 'uploads')))
app.use('/api_v1/', postRouter)

app.listen(4000, () => console.log('Server is running'))
app.get('/', (req, res) => {
    res.send('Hello World')
})
