// import express from 'express'
// import { AddCategory, DeleteCategory, NoOfCategories, UpdateCategory, getCategories, getOneCategory } from '../controllers/categories.js'

const express = require('express');
const { AddCategory, DeleteCategory, NoOfCategories, UpdateCategory, getCategories, getOneCategory } = require('../controllers/categories.js');

const router = express.Router()

router.post('/addcategory', AddCategory)
router.get('/categories', getCategories)
router.get('/categories/:id', getOneCategory)
router.get('/catcount', NoOfCategories)
router.delete('/deletecategory/:id', DeleteCategory)
router.put('/updatecategory/:id', UpdateCategory)

module.exports = router;