// import express from 'express'
// import { AddDraftPost, AddPost, DraftPostsCount, GetNoOfPosts, GetPosts, PublishedPostsCount, GetPublished, GetDrafts, DeletePost, GetSinglePost, UpdatePublishedPost, UpdateDraftPost } from '../controllers/post.js'

const express = require('express');
const { AddDraftPost, AddPost, DraftPostsCount, GetNoOfPosts, GetPosts, PublishedPostsCount, GetPublished, GetDrafts, DeletePost, GetSinglePost, UpdatePublishedPost, UpdateDraftPost } = require('../controllers/post.js');

const router = express.Router()

router.post('/addpost', AddPost)
router.post('/add_draft', AddDraftPost)
router.put('/update_published/:id', UpdatePublishedPost)
router.put('/update_draft/:id', UpdateDraftPost)
router.get('/getallposts', GetPosts)
router.get('/get_post/:id', GetSinglePost)
router.get('/getpublishedposts', GetPublished) 
router.get('/getdraftposts', GetDrafts)
router.get('/postscount', GetNoOfPosts)
router.get('/published', PublishedPostsCount)
router.get('/drafts', DraftPostsCount)

router.delete('/delete/:id', DeletePost)



module.exports = router;